(function () {
    // We use the same logic that Plugin uses to find their implementation in private assemblies.
    // From there we can find where our implementation files are in CommonExtensions
    var cookie;
    var pluginUrl = window.external.pluginUrl || (cookie = document.cookie.match(/(?:^|;)\s?pluginUrl=(.*?)(?:;|$)/)) && unescape(cookie[1]) || "plugin.b.js";

    var privateAssembliesUrl = pluginUrl.slice(0, pluginUrl.lastIndexOf('/'));
    var diagnosticsHubUrl = privateAssembliesUrl + "/../CommonExtensions/Platform/DiagnosticsHub/WebViews/Scripts/";

    var serviceHubScript = document.createElement("script");
    serviceHubScript.type = "text/javascript";
    serviceHubScript.src = pluginUrl.replace("plugin.vs.js", "serviceHub.all.js");

    var serviceHubRpcScript = document.createElement("script");
    serviceHubRpcScript.type = "text/javascript";
    serviceHubRpcScript.src = pluginUrl.replace("plugin.vs.js", "jsonRpc.all.js");

    var diagnosticsHubScript = document.createElement("script");
    diagnosticsHubScript.type = "text/javascript";
    diagnosticsHubScript.src = diagnosticsHubUrl + "DiagnosticsHub.Impl.js";

    document.head.appendChild(serviceHubScript);
    document.head.appendChild(serviceHubRpcScript);
    document.head.appendChild(diagnosticsHubScript);
})();

// SIG // Begin signature block
// SIG // MIIkBwYJKoZIhvcNAQcCoIIj+DCCI/QCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // /qgYftcpUyOcusI9fQx8r33XqP843FiT2FuyMrbjrBig
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcwwghXIAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbowGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIEGyEghSv/eAqWUwWqaP+Z7S6T92OjkYevtOA0Yf
// SIG // 2bPwME4GCisGAQQBgjcCAQwxQDA+oCSAIgBEAGkAYQBn
// SIG // AG4AbwBzAHQAaQBjAHMASAB1AGIALgBqAHOhFoAUaHR0
// SIG // cDovL21pY3Jvc29mdC5jb20wDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAO4wd+FV5CDvh5WhzqQf3/pPB7ItU8mZcB480o95O
// SIG // g5kh1CtX7mDY7v0xuBrJ5imKG8i+Ozv1thNz7sGUBVb5
// SIG // UpKFUy6xZyY0RBAlIrzuYjTgB1HXS4ud/IWbdStU4w0h
// SIG // sRkexDpp6cHJlPiC4U4neL9ARol1v2uoaDeoCdVt81b3
// SIG // AfSsnANh70B8wzS5WAcO3hRNJ0XjZMHjERqWJIItGahy
// SIG // UcCmg4yLEf4N22QDia9M8+S8yvOjQX2/MhOIVeh7zG5g
// SIG // 5q7OYwcbw+nS/9y+oebMS0ROmsfMNKb3+nBO07U13Hp8
// SIG // H2W7Hwvvha7jxhdv1vGjNsIdkyeZ2iNwNHrKT6GCE0ow
// SIG // ghNGBgorBgEEAYI3AwMBMYITNjCCEzIGCSqGSIb3DQEH
// SIG // AqCCEyMwghMfAgEDMQ8wDQYJYIZIAWUDBAIBBQAwggE9
// SIG // BgsqhkiG9w0BCRABBKCCASwEggEoMIIBJAIBAQYKKwYB
// SIG // BAGEWQoDATAxMA0GCWCGSAFlAwQCAQUABCCYN6BJzVXF
// SIG // tPAciaa4w7MTZvVxlwWlVwGGP72YoMDkOgIGWIurMill
// SIG // GBMyMDE3MDIwOTAzNDMzMS42NjVaMAcCAQGAAgH0oIG5
// SIG // pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQL
// SIG // EwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046
// SIG // RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7NMIIGcTCCBFmg
// SIG // AwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG9w0BAQsFADCB
// SIG // iDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UEAxMpTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcNMjUwNzAxMjE0
// SIG // NjU1WjB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQD
// SIG // Ex1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDCC
// SIG // ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKkd
// SIG // Dbx3EYo6IOz8E5f1+n9plGt0VBDVpQoAgoX77XxoSyxf
// SIG // xcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3OCROOfGEwWbEw
// SIG // RA/xYIiEVEMM1024OAizQt2TrNZzMFcmgqNFDdDq9UeB
// SIG // zb8kYDJYYEbyWEeGMoQedGFnkV+BVLHPk0ySwcSmXdFh
// SIG // E24oxhr5hoC732H8RsEnHSRnEnIaIYqvS2SJUGKxXf13
// SIG // Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOWRH7v0Ev9buWa
// SIG // yrGo8noqCjHw2k4GkbaICDXoeByw6ZnNPOcvRLqn9Nxk
// SIG // vaQBwSAJk3jN/LzAyURdXhacAQVPIk0CAwEAAaOCAeYw
// SIG // ggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1UdDgQWBBTV
// SIG // YzpcijGQ80N7fEYbxTNoWoVtVTAZBgkrBgEEAYI3FAIE
// SIG // DB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0T
// SIG // AQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV9lbLj+iiXGJo
// SIG // 0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEugSaBHhkVodHRw
// SIG // Oi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9k
// SIG // dWN0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcmww
// SIG // WgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNydDCBoAYDVR0g
// SIG // AQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEwPQYIKwYB
// SIG // BQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9Q
// SIG // S0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYIKwYBBQUH
// SIG // AgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwAaQBjAHkA
// SIG // XwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcN
// SIG // AQELBQADggIBAAfmiFEN4sbgmD+BcQM9naOhIW+z66bM
// SIG // 9TG+zwXiqf76V20ZMLPCxWbJat/15/B4vceoniXj+bzt
// SIG // a1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb3FwX/1z5Xhc1
// SIG // mCRWS3TvQhDIr79/xn/yN31aPxzymXlKkVIArzgPF/Uv
// SIG // eYFl2am1a+THzvbKegBvSzBEJCI8z+0DpZaPWSm8tv0E
// SIG // 4XCfMkon/VWvL/625Y4zu2JfmttXQOnxzplmkIz/amJ/
// SIG // 3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/fZZqkHimbdLh
// SIG // nPkd/DjYlPTGpQqWhqS9nhquBEKDuLWAmyI4ILUl5WTs
// SIG // 9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGnEcua2A5HmoDF
// SIG // 0M2n0O99g/DhO3EJ3110mCIIYdqwUB5vvfHhAN/nMQek
// SIG // kzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJrDm77MbL2IK0
// SIG // cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqHczsI5pgt6o3g
// SIG // My4SKfXAL1QnIffIrE7aKLixqduWsqdCosnPGUFN4Ib5
// SIG // KpqjEWYw07t0MkvfY3v1mYovG8chr1m1rtxEPJdQcdeh
// SIG // 0sVV42neV8HR3jDA/czmTfsNv11P6Z0eGTgvvM9YBS7v
// SIG // DaBQNdrvCScc1bN+NR4Iuto229Nfj950iEkSMIIE2jCC
// SIG // A8KgAwIBAgITMwAAALCG6ZIgCl3q+AAAAAAAsDANBgkq
// SIG // hkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDAeFw0xNjA5MDcxNzU2NTZaFw0xODA5MDcxNzU2
// SIG // NTZaMIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQL
// SIG // EwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046
// SIG // RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFNlcnZpY2UwggEiMA0GCSqGSIb3
// SIG // DQEBAQUAA4IBDwAwggEKAoIBAQDw5fCNlFmpmtdsCQd3
// SIG // FCFZXbc9eLg1rfUwMf/O4f/W6RrJg5gj+5AQwZLsOrxQ
// SIG // bJC9XPFrrUyi9WGlh+EprKM8Et9/xACCzr20Cl/Ludua
// SIG // txktWu0HAK1U/TOs9vgSJEokZ1fauEuhrA+A+Tm9IA21
// SIG // p8QsS/GhVubyLye5JsEzJdkrDDByUIRrkmqVjPL6CE24
// SIG // LiTVQ9Pc6/N0aoizybRg3MllrV8J5RFqFDTB5FcGEkbm
// SIG // oL2EWiRCQ/a89CxVmVqNs4imqhKUIr6GtUqJjKpHsKDF
// SIG // HxuPnPBibVSdMtOpxJtT6blyO78Xnq9YXJ3GK1Ahu9iW
// SIG // zDbvjaZz2a27Q3AVAgMBAAGjggEbMIIBFzAdBgNVHQ4E
// SIG // FgQU/KgHUtnvKf6YQzwVXHRet39z4K8wHwYDVR0jBBgw
// SIG // FoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUwVgYDVR0fBE8w
// SIG // TTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29t
// SIG // L3BraS9jcmwvcHJvZHVjdHMvTWljVGltU3RhUENBXzIw
// SIG // MTAtMDctMDEuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggr
// SIG // BgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29t
// SIG // L3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0w
// SIG // MS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQsFAAOCAQEAkv2A93W9
// SIG // ZZA+F83VFYPFjgKRO6xOfWDvjzkGk5DjD6pFPYk/Av3s
// SIG // b7hQkAlshNI3IZmxwYZ2HeQNxo7/GOCi+ka1hXd0bk4M
// SIG // REXQvNK2BH5wSw/WqwdpVkp2ZOj5qkejo4bc9M9EuEkQ
// SIG // W2eP0dp5rjrdh1MG6I9q/H/X5KOGRRUNkWIiOpBK49ho
// SIG // AUnJLQ5reGwRAvSPTRFgc6gDIQ2X4w9ydbv96A646/wg
// SIG // QZ2Ok/3FM3M+OXq9ajQeOUdiEbUc71f0c4Nxn6gUZb7k
// SIG // A45NbcQBMxt+V+yh8xyXqTin9Kg6OfmJNfxdoyKuCr2N
// SIG // DKsxEm7pvWEW7PQZOiSFYl+psqGCA3YwggJeAgEBMIHj
// SIG // oYG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYD
// SIG // VQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBF
// SIG // U046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFNlcnZpY2WiJQoBATAJBgUr
// SIG // DgMCGgUAAxUAvIT7nVsS2sc2hTuIZp6jFhjVzByggcIw
// SIG // gb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNV
// SIG // BAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgTlRTIEVT
// SIG // Tjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UEAxMiTWljcm9z
// SIG // b2Z0IFRpbWUgU291cmNlIE1hc3RlciBDbG9jazANBgkq
// SIG // hkiG9w0BAQUFAAIFANxGNIgwIhgPMjAxNzAyMDkwMDIx
// SIG // MjhaGA8yMDE3MDIxMDAwMjEyOFowdDA6BgorBgEEAYRZ
// SIG // CgQBMSwwKjAKAgUA3EY0iAIBADAHAgEAAgIBxjAHAgEA
// SIG // AgIbMDAKAgUA3EeGCAIBADA2BgorBgEEAYRZCgQCMSgw
// SIG // JjAMBgorBgEEAYRZCgMBoAowCAIBAAIDFuNgoQowCAIB
// SIG // AAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IBAQAYjBhhG6oL
// SIG // iiNv6mZogqxukoDvyR7/qklj9SnQgR3cq3XaBEnK5RUj
// SIG // qFylWQ4hdcz+VtdfPhwDB95pqsLxwkSuqt7PP57+qMwQ
// SIG // xp7GzGkYz5Yww9QXfepNIlQQYkQV+TgoJ721V0d/lIvc
// SIG // g+eSIqN0BciXCIEhMfvDXqtipg31ftSdx4yO02s4eMTV
// SIG // haIzz4PdSH0a/6iS3fIdXsPDyqjJZ3ICGYK5lV3irizg
// SIG // VWli51yKkzN89NnIw5U1fPhscCNu+D8WPH+vXgq96Qe3
// SIG // BuyvdwiJE7cgbNafH2P8nJUoXxGb/l/Xn/HgGw9po4M5
// SIG // h/GyFY32z1CPVM+mQ3HLA+dnMYIC9TCCAvECAQEwgZMw
// SIG // fDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAACw
// SIG // humSIApd6vgAAAAAALAwDQYJYIZIAWUDBAIBBQCgggEy
// SIG // MBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAvBgkq
// SIG // hkiG9w0BCQQxIgQgrKg8n319ZS6MVwXeID2a0PWw7KEw
// SIG // l23vMxhCWXq/l0AwgeIGCyqGSIb3DQEJEAIMMYHSMIHP
// SIG // MIHMMIGxBBS8hPudWxLaxzaFO4hmnqMWGNXMHDCBmDCB
// SIG // gKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMT
// SIG // HU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMz
// SIG // AAAAsIbpkiAKXer4AAAAAACwMBYEFFHUlpu9yIf7hQbE
// SIG // OljWLP8rKJ7cMA0GCSqGSIb3DQEBCwUABIIBAKDo4CB2
// SIG // lMmlAYAjcNlskofWy7b1sWzmBY+NZLhuK5e8DT2r+nXT
// SIG // FhCgx67K9FWqLMhy2+ERMuqfEhrhT1Rngr6H/JEmTVXZ
// SIG // SQnWXVuevCvHRC3qBmkiHG3Swa1w8ERNOOWYxTnBvJwN
// SIG // K5uRshHZbeV/W4OtIbwpi9bmrnVRfkHOAbRiiyfM8jS+
// SIG // 7En9hluzpYso30QbjUH0lKkJ/SqXOo9UpbLrex9xLVTA
// SIG // MT59fpYkkMc/4RD3Zs9eUPaFpAGilGxGsZGYokv3pZRB
// SIG // 1jDMiBUewMDo4fTgooFzSiAvW0n8+lqcaMvzOkaEeyw4
// SIG // jTx9o0gTdg7tJUTV95NViF9cNUQ=
// SIG // End signature block
